package nemosofts.voxradio.executor;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;

import nemosofts.voxradio.callback.Callback;
import nemosofts.voxradio.interfaces.PodcastsListener;
import nemosofts.voxradio.item.ItemPodcasts;
import nemosofts.voxradio.utils.ApplicationUtil;
import nemosofts.voxradio.utils.AsyncTaskExecutor;
import okhttp3.RequestBody;

public class LoadPodcasts extends AsyncTaskExecutor<String, String, String> {

    private final RequestBody requestBody;
    private final PodcastsListener podcastsListener;
    private final ArrayList<ItemPodcasts> arrayList = new ArrayList<>();
    private String verifyStatus = "0";
    private String message = "";

    public LoadPodcasts(PodcastsListener podcastsListener, RequestBody requestBody) {
        this.podcastsListener = podcastsListener;
        this.requestBody = requestBody;
    }

    @Override
    protected void onPreExecute() {
        podcastsListener.onStart();
        super.onPreExecute();
    }

    @Override
    protected String doInBackground(String strings) {
        try {
            String json = ApplicationUtil.responsePost(Callback.API_URL, requestBody);
            JSONObject mainJson = new JSONObject(json);
            JSONArray jsonArray = mainJson.getJSONArray(Callback.TAG_ROOT);

            for (int i = 0; i < jsonArray.length(); i++) {
                JSONObject objJson = jsonArray.getJSONObject(i);

                if (!objJson.has(Callback.TAG_SUCCESS)) {
                    String id = objJson.getString("pid");
                    String name = objJson.getString("podcast_name");
                    String image = objJson.getString("podcast_image").replace(" ", "%20");
                    if (image.isEmpty()) {
                        image = "null";
                    }

                    ItemPodcasts objItem = new ItemPodcasts(id, name, image);
                    arrayList.add(objItem);
                } else {
                    verifyStatus = objJson.getString(Callback.TAG_SUCCESS);
                    message = objJson.getString(Callback.TAG_MSG);
                }
            }
            return "1";
        } catch (Exception e) {
            return "0";
        }
    }

    @Override
    protected void onPostExecute(String s) {
        podcastsListener.onEnd(s, verifyStatus, message, arrayList);
    }
}